using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using BrRules = gov.va.med.vbecs.Common.VbecsBrokenRules.TimeZoneConfig;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// User control encapsulating logic for editing division time zone / daylight savings time configuration.
	/// </summary>
	public class EditDivisionTimeZoneConfig : BaseDivisionBoundControl
	{
		private BusinessObjectSortedHashList _daylightSavingsTypeDefs;
		private BusinessObjectSortedHashList _timeZones;

		private System.Windows.Forms.GroupBox grpTimeZoneConfig;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.ComboBox cmbDaylightSavingsType;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ComboBox cmbDivisionTimeZone;
		private gov.va.med.vbecs.admin.GUI.NullableDateTimePicker dtpDstStart;
		private gov.va.med.vbecs.admin.GUI.NullableDateTimePicker dtpDstEnd;

		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public EditDivisionTimeZoneConfig()
			: base( BrRules.FormClassName )
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
			FormatDatePicker();
		}

		/// <summary>
		/// BindValidator
		/// </summary>
		protected override void BindValidator()
		{
			InputValidator.SetControlBindings( cmbDivisionTimeZone, BrRules.TimeZoneNotSet );
			InputValidator.SetControlBindings( cmbDaylightSavingsType, BrRules.DaylightSavingsTypeNotSet );
			InputValidator.SetControlBindings( dtpDstStart, BrRules.CustomDaylightSavingsStartNotSet );
			InputValidator.SetControlBindings( dtpDstEnd, BrRules.CustomDaylightSavingsEndNotSet, BrRules.CustomDaylightSavingsStartGreatherThanEnd );			
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.grpTimeZoneConfig = new System.Windows.Forms.GroupBox();
			this.label4 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.cmbDaylightSavingsType = new System.Windows.Forms.ComboBox();
			this.label1 = new System.Windows.Forms.Label();
			this.cmbDivisionTimeZone = new System.Windows.Forms.ComboBox();
			this.dtpDstStart = new gov.va.med.vbecs.admin.GUI.NullableDateTimePicker();
			this.dtpDstEnd = new gov.va.med.vbecs.admin.GUI.NullableDateTimePicker();
			this.grpTimeZoneConfig.SuspendLayout();
			this.SuspendLayout();
			// 
			// grpTimeZoneConfig
			// 
			this.grpTimeZoneConfig.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTimeZoneConfig.Controls.Add(this.label4);
			this.grpTimeZoneConfig.Controls.Add(this.label3);
			this.grpTimeZoneConfig.Controls.Add(this.label2);
			this.grpTimeZoneConfig.Controls.Add(this.cmbDaylightSavingsType);
			this.grpTimeZoneConfig.Controls.Add(this.label1);
			this.grpTimeZoneConfig.Controls.Add(this.cmbDivisionTimeZone);
			this.grpTimeZoneConfig.Controls.Add(this.dtpDstStart);
			this.grpTimeZoneConfig.Controls.Add(this.dtpDstEnd);
			this.grpTimeZoneConfig.Location = new System.Drawing.Point(0, 0);
			this.grpTimeZoneConfig.Name = "grpTimeZoneConfig";
			this.grpTimeZoneConfig.Size = new System.Drawing.Size(572, 72);
			this.grpTimeZoneConfig.TabIndex = 25;
			this.grpTimeZoneConfig.TabStop = false;
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 44);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(116, 20);
			this.label4.TabIndex = 40;
			this.label4.Text = "Daylight Savings Start";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label3
			// 
			this.label3.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.label3.Location = new System.Drawing.Point(304, 44);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(112, 20);
			this.label3.TabIndex = 38;
			this.label3.Text = "Daylight Savings End";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label2
			// 
			this.label2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.label2.Location = new System.Drawing.Point(304, 16);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(112, 20);
			this.label2.TabIndex = 36;
			this.label2.Text = "Daylight Savings*";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbDaylightSavingsType
			// 
			this.cmbDaylightSavingsType.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmbDaylightSavingsType.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.erpMainProvider.SetIconAlignment(this.cmbDaylightSavingsType, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.cmbDaylightSavingsType.Items.AddRange(new object[] {
																		"US Standard DST",
																		"Do Not Observe DST",
																		"Custom DST"});
			this.cmbDaylightSavingsType.Location = new System.Drawing.Point(424, 16);
			this.cmbDaylightSavingsType.Name = "cmbDaylightSavingsType";
			this.cmbDaylightSavingsType.Size = new System.Drawing.Size(140, 21);
			this.cmbDaylightSavingsType.TabIndex = 35;
			this.cmbDaylightSavingsType.SelectedIndexChanged += new System.EventHandler(this.cmbDaylightSavingsType_SelectedIndexChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(64, 20);
			this.label1.TabIndex = 34;
			this.label1.Text = "Time Zone*";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbDivisionTimeZone
			// 
			this.cmbDivisionTimeZone.DisplayMember = "LongName";
			this.cmbDivisionTimeZone.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.erpMainProvider.SetIconAlignment(this.cmbDivisionTimeZone, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.cmbDivisionTimeZone.Location = new System.Drawing.Point(128, 16);
			this.cmbDivisionTimeZone.Name = "cmbDivisionTimeZone";
			this.cmbDivisionTimeZone.Size = new System.Drawing.Size(140, 21);
			this.cmbDivisionTimeZone.Sorted = true;
			this.cmbDivisionTimeZone.TabIndex = 0;
			this.cmbDivisionTimeZone.SelectedIndexChanged += new System.EventHandler(this.DataEntryFields_DataChanged);
			// 
			// dtpDstStart
			// 
			this.dtpDstStart.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.erpMainProvider.SetIconAlignment(this.dtpDstStart, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.dtpDstStart.Location = new System.Drawing.Point(128, 44);
			this.dtpDstStart.Name = "dtpDstStart";
			this.dtpDstStart.Size = new System.Drawing.Size(140, 20);
			this.dtpDstStart.TabIndex = 0;
			this.dtpDstStart.ValueChanged += new System.EventHandler(this.DataEntryFields_DataChanged);
			// 
			// dtpDstEnd
			// 
			this.dtpDstEnd.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.dtpDstEnd.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.erpMainProvider.SetIconAlignment(this.dtpDstEnd, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.dtpDstEnd.Location = new System.Drawing.Point(424, 44);
			this.dtpDstEnd.Name = "dtpDstEnd";
			this.dtpDstEnd.Size = new System.Drawing.Size(140, 20);
			this.dtpDstEnd.TabIndex = 0;
			this.dtpDstEnd.ValueChanged += new System.EventHandler(this.DataEntryFields_DataChanged);
			// 
			// EditDivisionTimeZoneConfig
			// 
			this.Controls.Add(this.grpTimeZoneConfig);
			this.Name = "EditDivisionTimeZoneConfig";
			this.Size = new System.Drawing.Size(572, 72);
			this.grpTimeZoneConfig.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Replaces OnLoad
		/// </summary>
		protected override void OnLoadInit()
		{		
#if !DESIGN
			base.OnLoadInit();

			DataLoadMode.Lock();

			_daylightSavingsTypeDefs = BOL.DaylightSavingsTypeDefinition.GetAllSortedByUse();
			PopulateDaylightSavingsTypeComboBox();

			_timeZones = BOL.TimeZone.GetAllSortedByName();
			PopulateTimeZoneComboBox();		

			DataLoadMode.Release();
#endif
		}

		private void PopulateTimeZoneComboBox()
		{
			GuiUtility.PopulateComboBoxFromList( cmbDivisionTimeZone, _timeZones, "LongName" );
		}

		private void PopulateDaylightSavingsTypeComboBox()
		{
			cmbDaylightSavingsType.SuspendLayout();

			cmbDaylightSavingsType.SelectedItem = null; 
			cmbDaylightSavingsType.Items.Clear();

			cmbDaylightSavingsType.DisplayMember = "Name";

			foreach( DaylightSavingsTypeDefinition _dstDef in _daylightSavingsTypeDefs )
				if( _dstDef.Type != DaylightSavingsType.Unknown )
					cmbDaylightSavingsType.Items.Add( _dstDef );

			cmbDaylightSavingsType.ResumeLayout();
		}

		/// <summary>
		/// DisplayData
		/// </summary>
		protected override void DisplayData()
		{
			grpTimeZoneConfig.Enabled = true;

			if( BoundDivision.TimeZoneConfig == null )
				BoundDivision.TimeZoneConfig = new TimeZoneConfig();

			if( !BoundDivision.TimeZoneConfig.IsNew )
				DisplayDefinedConfig();
			else
				ResetWidgetsToDefaultValues();
			
			UpdateCustomDstPickersState();
		}

		/// <summary>
		/// DisplayDefinedConfig
		/// </summary>
		protected virtual void DisplayDefinedConfig()
		{
			cmbDivisionTimeZone.SelectedItem = _timeZones.GetByObjectID( BoundDivision.TimeZoneConfig.TimeZone.ID );
			cmbDaylightSavingsType.SelectedItem = _daylightSavingsTypeDefs.GetByObjectID( BoundDivision.TimeZoneConfig.DaylightSavingsType );

			if( BoundDivision.TimeZoneConfig.DaylightSavingsType == DaylightSavingsType.Custom )
			{
				dtpDstStart.Value = BoundDivision.TimeZoneConfig.CustomDaylightSavingsStart;
				dtpDstEnd.Value = BoundDivision.TimeZoneConfig.CustomDaylightSavingsEnd;
			}
		}

		/// <summary>
		/// ResetUiToNoSelection
		/// </summary>
		protected override void ResetUiToNoSelection()
		{	
			DataLoadMode.Lock();

			ResetWidgetsToDefaultValues();

			DataLoadMode.Release();

			grpTimeZoneConfig.Enabled = false;
		}

		private void ResetWidgetsToDefaultValues()
		{			
			InputValidator.ClearValidationErrorsForAllBoundControls();

			cmbDivisionTimeZone.SelectedItem = null;
			cmbDaylightSavingsType.SelectedItem = null;

			DisableCustomDateTimePickers();
		}

		private void UpdateCustomDstPickersState()
		{			
			if( GetSelectedDaylightSavingsType() == DaylightSavingsType.Custom )
				EnableCustomDateTimePickers();
			else
				DisableCustomDateTimePickers();
		}

		private void EnableCustomDateTimePickers()
		{
			dtpDstStart.RestoreAndEnable();
			dtpDstEnd.RestoreAndEnable();
		}

		private void DisableCustomDateTimePickers()
		{
			dtpDstStart.Value = System.DateTime.Now;
			dtpDstEnd.Value = System.DateTime.Now;

			InputValidator.ClearValidationError( dtpDstStart );
			InputValidator.ClearValidationError( dtpDstEnd );

			dtpDstStart.ClearAndDisable();
			dtpDstEnd.ClearAndDisable();
		}

		private void cmbDaylightSavingsType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if( DataLoadMode.IsLocked )
				return;

			DataLoadMode.Lock();
			UpdateCustomDstPickersState();
			DataLoadMode.Release();

			DataEntryFields_DataChanged( sender, e );
		}

		/// <summary>
		/// Get BusinessObjectUnderValidation
		/// </summary>
		protected override BaseBusinessObject BusinessObjectUnderValidation
		{
			get
			{
				return BoundDivision.TimeZoneConfig;
			}
		}

		private DaylightSavingsType GetSelectedDaylightSavingsType()
		{
			DaylightSavingsTypeDefinition _selectedDstTypeDef = (DaylightSavingsTypeDefinition)cmbDaylightSavingsType.SelectedItem;
			return (_selectedDstTypeDef == null) ? DaylightSavingsType.Unknown : _selectedDstTypeDef.Type;
		}

		/// <summary>
		/// TransferUserInputToBoundDivisionObject
		/// </summary>
		protected override void TransferUserInputToBoundDivisionObject()
		{
			BoundDivision.TimeZoneConfig.TimeZone = (TimeZone)cmbDivisionTimeZone.SelectedItem;
			BoundDivision.TimeZoneConfig.DaylightSavingsType = GetSelectedDaylightSavingsType();

			if( BoundDivision.TimeZoneConfig.DaylightSavingsType == DaylightSavingsType.Custom )
			{
				BoundDivision.TimeZoneConfig.CustomDaylightSavingsStart = dtpDstStart.Value;
				BoundDivision.TimeZoneConfig.CustomDaylightSavingsEnd = dtpDstEnd.Value;
			}
		}

		private void FormatDatePicker()
		{
			this.dtpDstEnd.CustomFormat = "MMMM dd";
			this.dtpDstStart.CustomFormat = "MMMM dd";
		}
	}
}
